/*
 */
package bretopidesktop;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.omg.CORBA.ORBPackage.InconsistentTypeCode;
import scala.tools.nsc.backend.icode.Opcodes$opcodes$THIS;

/**
 * @author 
 */
public class RoleInconsistencyAnalyzer {

    private static String getDescriptives(ProcessModel pm) {
        String s = ""; 
        int roles = 0;
        int activities = 0;
        
        for(int i=0; i<pm.activityList.size(); i++)
        {
            boolean automatedExists = false;
            if(pm.activityList.get(i).elementType.equalsIgnoreCase("task"))
            {
                activities++;
                for(int j=0; j<pm.activityList.get(i).linkedEntities.size(); j++)
                {
                    if(pm.activityList.get(i).linkedEntities.get(j).type.equalsIgnoreCase("role") || pm.activityList.get(i).linkedEntities.get(j).type.equalsIgnoreCase("system"))
                    {
                        if(pm.activityList.get(i).linkedEntities.get(j).name.equalsIgnoreCase("AUTOMATED"))
                        {
                            automatedExists = true;
                        }
                        roles++;
                    }
                }
               if(automatedExists)
               {
                   roles = roles -1;
               }
            }
        }
        s = s + pm.processArea + "\t" + pm.processID + "\t" + String.valueOf(activities) + "\t" + String.valueOf(roles);
        return s;
    }
    
    public HashMap<String,String> hmLocalContextRoleHierarchy;
    public static List<RoleInconsistency> inconsistencyList;
    public RoleInconsistencyAnalyzer()
    {
        
    }
    
    private static HashMap buildHierarchicalLocalContextRoles(LocalContext lc)
    {
        HashMap hm = new HashMap();
        
        for(int i=0; i<lc.orgRoleList.size(); i++)
        {
            String[] s = lc.orgRoleList.get(i).name.split(" ");
            String key = s[s.length-1].toLowerCase();

            if(!hm.containsKey(key))
            {
                hm.put(key, lc.orgRoleList.get(i).name);
            }
            else
            {
                String val = hm.get(key).toString();
                val = val + ", " + lc.orgRoleList.get(i).name;
                hm.replace(key, val);
            }
        }
    
        return hm;
    }
    
     private static List<LocalContextEntity> getOnlySystemsAndRoles(List<LocalContextEntity> lcList)
    {
        List<LocalContextEntity> onlySystemsAndRoles = new ArrayList<LocalContextEntity>();
        for(int i=0; i<lcList.size(); i++)
        {
            if(lcList.get(i).type.equalsIgnoreCase("System") || lcList.get(i).type.equalsIgnoreCase("Role"))
            {
                onlySystemsAndRoles.add(lcList.get(i));
            }
        }
        onlySystemsAndRoles = Common.getUniqueLocalContextSet(onlySystemsAndRoles);
        return onlySystemsAndRoles;
    }
    
     private static List<LocalContextEntity> getSubjectLCEntities(ProcessActivity pa)
    {
        String retStr = "";
        List<LocalContextEntity> lcLinkedITSystems = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcLinkedRoles = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcITSystems = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcRoles = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcRolesAndSystemsAsSubjects = new ArrayList<LocalContextEntity>();
    
        for(int i=0; i<pa.linkedEntities.size(); i++)
        {
            if(pa.linkedEntities.get(i).type.equalsIgnoreCase("Role"))
            {
                lcLinkedRoles.add(pa.linkedEntities.get(i));
            }
            if(pa.linkedEntities.get(i).type.equalsIgnoreCase("System"))
            {
                lcLinkedITSystems.add(pa.linkedEntities.get(i));
            }
        }
        for(int i=0; i<pa.descriptionSentence.localContextEntityList.size(); i++)
        {
            if(pa.descriptionSentence.localContextEntityList.get(i).type.equalsIgnoreCase("Role"))
            {
                lcRoles.add(pa.descriptionSentence.localContextEntityList.get(i));
            }
            if(pa.descriptionSentence.localContextEntityList.get(i).type.equalsIgnoreCase("System"))
            {
                lcITSystems.add(pa.descriptionSentence.localContextEntityList.get(i));
            }
        }
        

        for(int i=0; i<pa.descriptionSentence.subjects.size(); i++)
        {     
             for(int j=0; j<lcRoles.size(); j++)
             {
                 if(Common.containsWithoutCharacterBounds(lcRoles.get(j).name, pa.descriptionSentence.subjects.get(i)))
                 {
                     lcRolesAndSystemsAsSubjects.add(lcRoles.get(j));
                 }
                 else 
                 {
                   if(Common.containsWithoutCharacterBounds(pa.descriptionSentence.subjects.get(i), lcRoles.get(j).name))
                   {
                       lcRolesAndSystemsAsSubjects.add(lcRoles.get(j));
                   }
                 }
             }
             for(int j=0; j<lcITSystems.size(); j++)
             {
                 if(Common.containsWithoutCharacterBounds(lcITSystems.get(j).name, pa.descriptionSentence.subjects.get(i)))
                 {
                     lcRolesAndSystemsAsSubjects.add(lcITSystems.get(j));
                 }
                 else 
                 {
                    if(Common.containsWithoutCharacterBounds(pa.descriptionSentence.subjects.get(i),lcITSystems.get(j).name))
                    {
                        lcRolesAndSystemsAsSubjects.add(lcITSystems.get(j));
                    }
                 }
             }    
        }
         lcRolesAndSystemsAsSubjects = Common.getUniqueLocalContextSet(lcRolesAndSystemsAsSubjects);
        return lcRolesAndSystemsAsSubjects;
    }

    private static String checkInconsistency(ProcessActivity pa, LocalContext lContext)
    {
        String retStr = "";
        List<RoleInconsistency> inconsistenciesOfThisActivity = new ArrayList<RoleInconsistency>();
        List<LocalContextEntity> lcLinkedITSystems = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcLinkedRoles = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcITSystems = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcRoles = new ArrayList<LocalContextEntity>();
        List<LocalContextEntity> lcRolesAndSystemsAsSubjects = new ArrayList<LocalContextEntity>();
        
        lcRolesAndSystemsAsSubjects = getSubjectLCEntities(pa);
        List<String> mentionedDetrminers = getDeterminerMentionsList(lContext, pa.descriptionSentence.subjects); // 
        
        // Populate the linked Roles and linked Systems
        for(int i=0; i<pa.linkedEntities.size(); i++)
        {
            if(pa.linkedEntities.get(i).type.equalsIgnoreCase("Role"))
            {
                lcLinkedRoles.add(pa.linkedEntities.get(i));
            }
            if(pa.linkedEntities.get(i).type.equalsIgnoreCase("System"))
            {
                lcLinkedITSystems.add(pa.linkedEntities.get(i));
            }
        }
        
        // Populate the mentioned LC Roles and LC Systems
        for(int i=0; i<pa.descriptionSentence.localContextEntityList.size(); i++)
        {
            if(pa.descriptionSentence.localContextEntityList.get(i).type.equalsIgnoreCase("Role"))
            {
                lcRoles.add(pa.descriptionSentence.localContextEntityList.get(i));
            }
            if(pa.descriptionSentence.localContextEntityList.get(i).type.equalsIgnoreCase("System"))
            {
                lcITSystems.add(pa.descriptionSentence.localContextEntityList.get(i));
            }
        }
        

      
            // *******************************************
            // TYPE-2 PROBLEM:  Missing role in the model.
            

            
            for(int i=0; i<lcRolesAndSystemsAsSubjects.size(); i++) // Rule 2.1: Each and every one of the mentioned roles and systems that are also subjects must be linked!
            {
                boolean isLinked = false;
                boolean partLink1 = false;
                for(int x=0; x<lcLinkedRoles.size(); x++) // Check the linked roles
                {
                    if(lcRolesAndSystemsAsSubjects.get(i).name.equalsIgnoreCase(lcLinkedRoles.get(x).name) // Is the mentioned role or system linked?
                            || Common.containsWithoutCharacterBounds(lcLinkedRoles.get(x).name, lcRolesAndSystemsAsSubjects.get(i).name)) // Is a specific type of the mentioned role or system linked?
                    {
                        isLinked = true;
                    }
                }
                if(lcRolesAndSystemsAsSubjects.get(i).type.equalsIgnoreCase("System")) // there is a special case for the mentioned systems
                {
//                    
                    for(int x=0; x<lcLinkedITSystems.size(); x++) // check the linked systems
                    {
                        if(lcRolesAndSystemsAsSubjects.get(i).name.equalsIgnoreCase(lcLinkedITSystems.get(x).name))
                        {
                            isLinked = true;
                        }
                    }
                    
                    
                }
                if(!isLinked)
                {
                    RoleInconsistency ri = new RoleInconsistency();
                    ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE2_MISSING_ROLE;
                    ri.id = pa.id;
                    ri.focusEntity =  lcRolesAndSystemsAsSubjects.get(i).name;
                    
                    if(!RoleInconsistency.isInMatching(ri, inconsistenciesOfThisActivity))
                    {
                        retStr = retStr + "\n<span class=\"badge badge-danger\">Type 2</span> " + lcRolesAndSystemsAsSubjects.get(i).name + " is not linked";
                        //inconsistencyList.add(ri);
                        inconsistenciesOfThisActivity.add(ri);
                    }
                }
            }
            
            
            for(int i=0; i<mentionedDetrminers.size(); i++) // Now we check the mentioned determiners
            {
                boolean isLinked = false;
                if(isTheMentionedDeterminerNextToWord(mentionedDetrminers.get(i), pa.descriptionSentence.originalSentence))
                {


                
                    if(mentionedDetrminers.get(i).equalsIgnoreCase("system")) // if the mentioned determiner is "system"
                    {

                            if(lcLinkedITSystems.size() > 0) // check if there is at least an IT system linked or not
                            {
                                isLinked = true;
                            }

                    }

                    if(!mentionedDetrminers.get(i).equalsIgnoreCase("system")) // if the mentioned determiner is not "system"
                    {

                            for(int j=0; j<lcLinkedRoles.size(); j++) // check the linked roles to see if the specific type of the determiner exists or not
                            {
                                if(Common.containsWithoutCharacterBounds(lcLinkedRoles.get(j).name,mentionedDetrminers.get(i)))
                                {


                                        isLinked = true;

                                }

                            }
                        
                    }
                    if(!isLinked)
                    {
                        RoleInconsistency ri = new RoleInconsistency();
                        ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE2_MISSING_ROLE;
                        ri.id = pa.id;
                        ri.focusEntity =  mentionedDetrminers.get(i);
                        if(!RoleInconsistency.isInMatching(ri, inconsistenciesOfThisActivity))
                        {
                            retStr = retStr + "\n<span class=\"badge badge-danger\">Type 2</span> detected: Determiner " + mentionedDetrminers.get(i) + " is not linked";
                            //inconsistencyList.add(ri);
                            inconsistenciesOfThisActivity.add(ri);
                        }
                    }
                }
            }
            
            
            // *******************************************
            // TYPE-3 PROBLEM:  Linked role is not mentioned in the description.
            

            boolean type1ExistsSoDontCheckType3 = false;
            if(lcLinkedRoles.size() > 1)
            {
                if(lcRolesAndSystemsAsSubjects.size() + mentionedDetrminers.size() == 0)
                {
                    type1ExistsSoDontCheckType3 = true;
                }
            }
            else if(lcLinkedRoles.size() == 1)
            {
                if(lcLinkedRoles.get(0).name.equalsIgnoreCase("AUTOMATED") && lcLinkedITSystems.size() > 1)
                {
                    if(lcRolesAndSystemsAsSubjects.size() + mentionedDetrminers.size() == 0)
                    {
                        type1ExistsSoDontCheckType3 = true;
                    }    
                }
            }
            
            boolean checkType3and1 = true;
            if(lcLinkedRoles.size()==1)
            {
                if(!lcLinkedRoles.get(0).name.equalsIgnoreCase("AUTOMATED"))
                {
                    if(lcLinkedITSystems.size()==0) // partial is yapiliyor olabilir bu durumda. tip 3 olmali. 
                    {
                        checkType3and1 = false;
                    }
                }
                else // Role  is AUTOMATED
                {
                    if(lcLinkedITSystems.size()==1)
                    {
                        checkType3and1 = false;
                    }
                }
            }
            
            if(checkType3and1)
            {
               
                if(!type1ExistsSoDontCheckType3)
                {
                    //lcLinkedRoles kumesinde rol var, ama bu rol LCRoles kumesinde ve subject kumesinde yok.  
                   for(int i=0; i<lcLinkedRoles.size(); i++)
                   {
                       boolean isMentioned = false;

 
                       if(lcLinkedRoles.get(i).name.equalsIgnoreCase("AUTOMATED"))
                       {
                           isMentioned = true;
                       }

                           for(int x=0; x< lcRolesAndSystemsAsSubjects.size(); x++) // All linked roles and systems should be mentioned
                           {
                               if(lcLinkedRoles.get(i).name.equalsIgnoreCase(lcRolesAndSystemsAsSubjects.get(x).name))
                               {
                                   isMentioned = true;
                               }
                               if(isATypeOf(lcLinkedRoles.get(i).name, lcRolesAndSystemsAsSubjects.get(x).name))
                               //if(Common.containsWithoutCharacterBounds(lcLinkedRoles.get(i).name, lcRolesAndSystemsAsSubjects.get(x).name))
                               {
                                   isMentioned = true;
                               }

                           }

                           for(int x=0; x< mentionedDetrminers.size(); x++) // Check the determiners
                           {
                              
                               //if(isATypeOf(lcLinkedRoles.get(i).name, mentionedDetrminers.get(x)))
                               if(Common.containsWithoutCharacterBounds(lcLinkedRoles.get(i).name, mentionedDetrminers.get(x)))
                               {
                                    if(isTheMentionedDeterminerNextToWord(mentionedDetrminers.get(x), pa.descriptionSentence.originalSentence))
                                    {
                                        isMentioned = true;
                                    }
                               }

                           }
                       if(!isMentioned)
                       {
                           retStr = retStr + "\n<span class=\"badge badge-warning\">Type 3</span> detected: " + lcLinkedRoles.get(i).name + " is not mentioned";
                           RoleInconsistency ri = new RoleInconsistency();
                            ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE_3_REDUNDANCY;
                            ri.id = pa.id;
                            ri.focusEntity = lcLinkedRoles.get(i).name;
                            //inconsistencyList.add(ri);
                            inconsistenciesOfThisActivity.add(ri);
                       }
                   }

                   for(int i=0; i<lcLinkedITSystems.size(); i++)
                   {
                       boolean isMentioned = false;

  

                       for(int x=0; x< lcITSystems.size(); x++) // All linked roles and systems should be mentioned   ( aslinda lcRolesAndSystemsAsSubjects olmaliyken sadece SUBJ olmasin, OBJ da olsun diye  lcITSystems yaptik
                       {
                           if(lcLinkedITSystems.get(i).name.equalsIgnoreCase(lcITSystems.get(x).name))
                           {
                               isMentioned = true;
                           }

                       }

                       for(int x=0; x< mentionedDetrminers.size(); x++) // Check the determiners
                       {
                           
                           if(mentionedDetrminers.get(x).equalsIgnoreCase("system"))
                           {
                               if(isTheMentionedDeterminerNextToWord("system", pa.descriptionSentence.originalSentence))
                               {
                                    isMentioned = true;
                               }
                               
                           }

                       }
                       if(!isMentioned)
                       {
                           retStr = retStr + "\n<span class=\"badge badge-warning\">Type 3</span> detected: " + lcLinkedITSystems.get(i).name + " is not mentioned";
                           RoleInconsistency ri = new RoleInconsistency();
                            ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE_3_REDUNDANCY;
                            ri.id = pa.id;
                            ri.focusEntity = lcLinkedITSystems.get(i).name;
                            //inconsistencyList.add(ri);
                            inconsistenciesOfThisActivity.add(ri);
                       }
                   }

                }
               
               
            }
            
            
            // *******************************************
            // TYPE-1 PROBLEM: Ambiguity detected
            // No subject (
            // .
            if(checkType3and1)
            {
                // determinerlerden birden fazla varsa
                
                for(int i=0; i<mentionedDetrminers.size(); i++)
                {
                    if(mentionedDetrminers.get(i).equalsIgnoreCase("system"))
                    {
                        if(isTheMentionedDeterminerNextToWord("system", pa.descriptionSentence.originalSentence))
                        {
                            if(lcLinkedITSystems.size()>1)
                            {
                                retStr = retStr + "\n<span class=\"badge badge-info\">Type 1</span> detected: " + mentionedDetrminers.get(i) + " is ambiguous.";
                                RoleInconsistency ri = new RoleInconsistency();
                                ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE1_AMBIGUITY;
                                ri.id = pa.id;
                                ri.focusEntity = mentionedDetrminers.get(i);
                                //inconsistencyList.add(ri);
                                inconsistenciesOfThisActivity.add(ri);
                            }
                        }
                    }
                    else 
                    {
                        if(isTheMentionedDeterminerNextToWord(mentionedDetrminers.get(i), pa.descriptionSentence.originalSentence))
                        {
                        int count = 0;
                            for(int j=0; j<lcLinkedRoles.size(); j++)
                            {
                                if(Common.containsWithoutCharacterBounds(lcLinkedRoles.get(j).name, mentionedDetrminers.get(i)))
                                {
                                    count++;
                                }
                            }
                            if(count>1)
                            {
                                retStr = retStr + "\n<span class=\"badge badge-info\">Type 1</span> detected: " + mentionedDetrminers.get(i) + " is ambiguous.";
                                RoleInconsistency ri = new RoleInconsistency();
                                ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE1_AMBIGUITY;
                                ri.id = pa.id;
                                ri.focusEntity = mentionedDetrminers.get(i);
                                //inconsistencyList.add(ri);
                                inconsistenciesOfThisActivity.add(ri);
                            }
                        }
                    }
                }
                
                if(type1ExistsSoDontCheckType3)
                {
                    retStr = retStr + "\n<span class=\"badge badge-info\">Type 1</span> detected: " + "no subject exists but multiple linked entites";
                    RoleInconsistency ri = new RoleInconsistency();
                    ri.inconsistencyType = RoleInconsistency.RoleInconsistencyType.TYPE1_AMBIGUITY;
                    ri.id = pa.id;
                    ri.focusEntity = "NO_SUBJECT";
                    //inconsistencyList.add(ri);
                    inconsistenciesOfThisActivity.add(ri);
                }
            
            }
                    
                //retStr = inconsistencyListToString(inconsistenciesOfThisActivity);
                inconsistenciesOfThisActivity = eliminateGenericErrorsIfSpecificErrorExists(inconsistenciesOfThisActivity);
                retStr = retStr + "<LI>" + inconsistencyListToString(inconsistenciesOfThisActivity);
                inconsistencyList.addAll(inconsistenciesOfThisActivity);
        return retStr;
    }
    
    private static boolean isATypeOf(String specificEntity, String genericEntity)
    {
         if(Common.containsWithoutCharacterBounds(specificEntity, genericEntity))
         {
             if(Common.containsWithoutCharacterBounds(specificEntity.substring(specificEntity.lastIndexOf(" ")+1), genericEntity))
             {
                return true;
             }
         }
         return false;
    }
    
    private static List<RoleInconsistency> eliminateGenericErrorsIfSpecificErrorExists(List<RoleInconsistency> incList)
    {
        List<RoleInconsistency> thinList = new ArrayList<RoleInconsistency>();
        for(int i=0; i<incList.size(); i++)
        {
            boolean isRedundantError = false;
            for(int j=0; j<incList.size(); j++)
            {
                if(i!=j)
                {
                    if(Common.containsWithoutCharacterBounds(incList.get(j).focusEntity, incList.get(i).focusEntity) && incList.get(i).inconsistencyType == incList.get(j).inconsistencyType)
                    {
                        isRedundantError = true;
                    }
                }
            }
            if(!isRedundantError)
            {
                thinList.add(incList.get(i));
            }
        }
        return thinList;
    }
    
    private static String inconsistencyListToString(List<RoleInconsistency> incList)
    {
        String retStr = "";
        
        for(int i=0; i<incList.size(); i++)
        {
            if( incList.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE1_AMBIGUITY)
            {
                retStr = retStr + "<BR><span class=\"badge badge-info\">Type 1</span>  :" + incList.get(i).focusEntity;
            }
            else if( incList.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE2_MISSING_ROLE)
            {
                retStr = retStr + "<BR><span class=\"badge badge-danger\">Type 2</span>  :" + incList.get(i).focusEntity;
            }
            else if( incList.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE_3_REDUNDANCY)
            {
                retStr = retStr + "<BR><span class=\"badge badge-warning\">Type 3</span>  :" + incList.get(i).focusEntity;
            }
            else if( incList.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.GENERIC)
            {
                retStr = retStr + "<BR><span class=\"badge badge-primary\">GENERIC</span>  :" + incList.get(i).focusEntity;
            }
        }
        
        return retStr;
    }
    
    private static String getDeterminerMentions(LocalContext lContext, List<String> subjs)
    {
        String det = "";
        HashMap<String, String> hm = buildHierarchicalLocalContextRoles(lContext);
        for(int i=0; i<subjs.size(); i++)
        {
            if(subjs.get(i).equalsIgnoreCase("system"))
            {
                det = det + subjs.get(i);
            }
            if(hm.containsKey(subjs.get(i).toLowerCase()))
            {
                
                if(hm.get(subjs.get(i).toLowerCase()).split(",").length>1)
                    {
                    if(det.length()>0)
                    {
                        det = det + ", " + subjs.get(i);
                    }
                    else
                    {
                        det = det + subjs.get(i);
                    }
                }
            }
            else
            {    
                if(hm.containsKey(subjs.get(i))) 
                {

                    if(hm.get(subjs.get(i)).split(",").length>1)
                        {
                        if(det.length()>0)
                        {
                            det = det + ", " + subjs.get(i);
                        }
                        else
                        {
                            det = det + subjs.get(i);
                        }
                    }
                }
            }
        }
       return det;
    }
    
     private static List<String> getDeterminerMentionsList(LocalContext lContext, List<String> subjs)
    {
        List<String> det = new ArrayList<String>();
        HashMap<String, String> hm = buildHierarchicalLocalContextRoles(lContext);
        for(int i=0; i<subjs.size(); i++)
        {
            if(subjs.get(i).equalsIgnoreCase("system"))
            {
                det.add(subjs.get(i));
            }
            if(hm.containsKey(subjs.get(i).toLowerCase()))
            {
                String s = hm.get(subjs.get(i).toLowerCase());
                //if(hm.get(subjs.get(i)).split(",").length>1)
                if(s.split(",").length>1)
                {
                   det.add(subjs.get(i));
                }
            }
            else
            {
                if(hm.containsKey(subjs.get(i)))
                {
                    String s = hm.get(subjs.get(i));
                    //if(hm.get(subjs.get(i)).split(",").length>1)
                    if(s.split(",").length>1)
                    {
                       det.add(subjs.get(i));
                    }
                }
            }
        }
       return det;
    }
    
     private static boolean isTheMentionedDeterminerNextToWord(String word, String description)
     {
         boolean ret = false;
        
         String search;
         search = "the " + word;
         if(Common.containsWithoutCharacterBounds(description.toLowerCase(), search.toLowerCase()))
         {
             ret = true;
         }
         search = "a " + word;
         if(Common.containsWithoutCharacterBounds(description.toLowerCase(), search.toLowerCase()))
         {
             ret = true;
         }
         search = "an " + word;
         if(Common.containsWithoutCharacterBounds(description.toLowerCase(), search.toLowerCase()))
         {
             ret = true;
         }
         search = "all " + word;
         if(Common.containsWithoutCharacterBounds(description.toLowerCase(), search.toLowerCase()))
         {
             ret = true;
         }
         search = "these " + word;
         if(Common.containsWithoutCharacterBounds(description.toLowerCase(), search.toLowerCase()))
         {
             ret = true;
         }
         
         return ret;
     }
     
    private static void printHashMap(HashMap<String, String> hm)
    {
       for (String key : hm.keySet()) 
       {
            System.out.println(key + "= " + hm.get(key));
       }       
    }
    // REMOVE END EVENT, START EVENT
    
    public static boolean writeToHTMLFileFancy(List<ProcessModel> pmList, String filePath, LocalContext lContext)
    {
        boolean ret = false;
        String retHTML ="";
        int matchingNo = 1;
        int processCount = 0;
        int activityCount = 0;
        List<ProcessHierarchy> ph = new ArrayList<ProcessHierarchy>();
        inconsistencyList = new ArrayList<RoleInconsistency>();
        String taskIDList ="";
        //printHashMap(buildHierarchicalLocalContextRoles(lContext));
        
        try {
            FileWriter fw = new FileWriter(filePath);
            

            fw.write("<HTML><head>\n" +
"    <link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/css/bootstrap.min.css\" integrity=\"sha384-rwoIResjU2yc3z8GV/NPeZWAv56rSmLldC3R/AZzGRnGxQQKnKkoFVhFQhNUwEyJ\" crossorigin=\"anonymous\">\n" +
"    <script src=\"https://code.jquery.com/jquery-3.1.1.slim.min.js\" integrity=\"sha384-A7FZj7v+d/sdmMqp/nOQwliLvUsJfDHW+k9Omg/a/EheAdgtzNs3hpfag6Ed950n\" crossorigin=\"anonymous\"></script>\n" +
"    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/tether/1.4.0/js/tether.min.js\" integrity=\"sha384-DztdAPBWPRXSA/3eYEEUWrWCy7G5KFbe8fFjk5JAIxUYHKkDx6Qin1DkWx51bBrb\" crossorigin=\"anonymous\"></script>\n" +
"    <script src=\"https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/js/bootstrap.min.js\" integrity=\"sha384-vBWWzlZJ8ea9aCX4pEW3rVHjgjt7zpkNpZk+02D9phzyeVkE+jo0ieGizqPLForn\" crossorigin=\"anonymous\"></script>\n" +
"    <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\"></head>"  + System.lineSeparator());
          fw.write("<body><div class=\"container\">\n");
          
            String currentSentence = "";
            String pmTitle = "";
            for (int x=0; x<pmList.size(); x++)
            {
                pmTitle = pmList.get(x).titleSentence.originalSentence;
                String id = pmList.get(x).processID;

                    System.out.println(getDescriptives(pmList.get(x)));
                    processCount++;
                    retHTML = "<div class=\"card\" id=\"card_" + "\"><div class=\"card-block\"><div class=\"row\">";
                    retHTML = retHTML + "<div class=\"col-md-5\">" + pmList.get(x).processArea + " > " + pmList.get(x).titleSentence.originalSentence  + "</div>";

                    for (int y=0; y<pmList.get(x).activityList.size(); y++)
                    {
                        if(pmList.get(x).activityList.get(y).elementType.equalsIgnoreCase("TASK"))
                        {
                            Common.log(String.valueOf(processCount) + " > " + String.valueOf(x) + ":" + String.valueOf(y));
                       activityCount++;
                       taskIDList = taskIDList + " " + pmList.get(x).activityList.get(y).id;
                        ProcessHierarchy p1 = new ProcessHierarchy();
                        p1.domain = pmList.get(x).processArea;
                        p1.processID = pmList.get(x).processID;
                        p1.taskID = pmList.get(x).activityList.get(y).id;
                        ph.add(p1);
                        retHTML = retHTML + "                <div class=\"card-footer\">\n" + // card footer open
    "                    <div class=\"row\">\n" + // row open
    "                        <div class=\"col-md-6\">\n" + // col descriptions open
     "                        <ul class=\"list-group\" style=\"margin-bottom:15px;\">\n" +
    "                                <li class=\"list-group-item active\">" + pmList.get(x).activityList.get(y).labelSentence.originalSentence +  "</li>\n" + 
    "                                <li class=\"list-group-item\">" + pmList.get(x).activityList.get(y).id +  "</li>\n" +
    "                                <li class=\"list-group-item\">\n" + pmList.get(x).activityList.get(y).descriptionSentence.originalSentence + "</li>\n" +
    //"                                <li class=\"list-group-item\">\nLinked Entities: " + Common.localContextEntitiesToString(pmList.get(x).activityList.get(y).linkedEntities) + "</li>\n" +
    "                                <li class=\"list-group-item\">\nLinked Entities: " + Common.localContextEntitiesToString(getOnlySystemsAndRoles(pmList.get(x).activityList.get(y).linkedEntities)) + "</li>\n" +                          
                                
                                "<li class=\"list-group-item\">\n Inconsistencies: " + checkInconsistency(pmList.get(x).activityList.get(y), lContext) +
                                
                                
    "                            </ul>\n" +
    "                        </div>\n" + // col descriptions close
    "                        <div class=\"col-md-6\">\n" + // col analysis open
    "                       <div class=\"row\">\n" +      // row for analysis col open                       
    "                           <ul class=\"list-group\" style=\"margin-bottom:15px;\">\n" +
    
    "                                <li class=\"list-group-item\">\nLC Sys and roles : " + Common.localContextEntitiesToString(getOnlySystemsAndRoles(pmList.get(x).activityList.get(y).descriptionSentence.localContextEntityList)) + "</li>\n" +
    "                                <li class=\"list-group-item\">\nSubjects: " + pmList.get(x).activityList.get(y).descriptionSentence.subjects + "</li>\n" +            
                                "<li class=\"list-group-item\">\n Subject LC Entities: " + Common.localContextEntitiesToString(getSubjectLCEntities(pmList.get(x).activityList.get(y))) +
                                "<li class=\"list-group-item\">\n Mentioned determiners: " + getDeterminerMentions(lContext, pmList.get(x).activityList.get(y).descriptionSentence.subjects) +
    "                            </ul>\n" +       
    "                    </div>\n" + // row for analysis col close                     
    "                </div>\n" +// col analysis close
    "            </div>" + // row main close
    "       </div>"; // card footer close
                    }
                        }
                    retHTML = retHTML + "       </div></div></div>";

                    fw.write(retHTML);
                    
                
            }
            fw.write("</div>");
            // PRINT OUT THE INCONSISTENCY LIST
            // printInconsistencyList(inconsistencyList);
            RoleInconsistency ri = new RoleInconsistency();
            String out = ri.compareGoldStandard(inconsistencyList, ph);
            ri.getDescriptivesOfInconsistencies(ph);
            fw.write(out  + System.lineSeparator());
            fw.write("Model count: " + String.valueOf(processCount) +  " | Activity count: " + String.valueOf(activityCount) + System.lineSeparator());
            fw.write("</BODY></HTML>"  + System.lineSeparator());
            fw.close();
            
            ret = true;
        }
        catch (Exception e)
        {
            System.out.println(e);
            ret = false;
        }
       
        return ret;
    } 
    
    private static void printInconsistencyList(List <RoleInconsistency> list)
    {
        try {
                FileWriter fw = new FileWriter("C:\\VDF\\bas.txt");

               

            for(int i=0; i<list.size(); i++)
            {
                String type = "GENERIC";

                if(list.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE1_AMBIGUITY)
                {
                type = "TYPE1_AMBIGUITY";
                }
                if(list.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE2_MISSING_ROLE)
                {
                type = "TYPE2_MISSING_ROLE";
                }
                if(list.get(i).inconsistencyType == RoleInconsistency.RoleInconsistencyType.TYPE_3_REDUNDANCY)
                {
                type = "TYPE_3_REDUNDANCY";
                }

            String l1 =  "ri = new RoleInconsistency();\n";
            String l2 = "ri.id = \"" + list.get(i).id + "\";\n";
            String l3= "ri.focusEntity = \"" + list.get(i).focusEntity +  "\";\n";
            String l4 = "ri.inconsistencyType = RoleInconsistencyType." + type + ";\n";
            String l5 = "goldStandard.add(ri);\n\n";

            fw.write(l1 + l2 + l3 + l4 + l5);

            }
            fw.close();
        }
        catch (Exception e)
        {
            System.out.println(e);
          
        }
        
    }
    
}
