/*

 */
package bretopidesktop;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import java.io.File;
import java.io.FileWriter;
import java.util.UUID;


/**

 */
public class ProcessModel implements java.io.Serializable {
  public String processID;
  public String processArea;
  public int processLevel;
  public boolean isLeaf;
  public bretopidesktop.Sentence descriptionSentence;
  public bretopidesktop.Sentence titleSentence;
  public bretopidesktop.Sentence concatenatedTitleTaskDescriptionsAndLabels;
  public List<ProcessActivity> activityList;

  public List<LocalContextEntity> localContextEntityList;
  
  public ProcessModel()
  {
    processID="";
    processArea = "";
    processLevel = -1;
    isLeaf = false;

    descriptionSentence = new bretopidesktop.Sentence();
    titleSentence = new bretopidesktop.Sentence();
    concatenatedTitleTaskDescriptionsAndLabels = new bretopidesktop.Sentence();
    activityList = new ArrayList<ProcessActivity>();
    localContextEntityList = new ArrayList<LocalContextEntity>();
  }
  
  public static void main(String argv[]) {
      ProcessModel p = new ProcessModel();
      
  }
  
  
   public boolean writeToFile(List<ProcessModel> pmList, String filePath)
    {
        boolean ret = false;
        
        try {
            FileWriter fw = new FileWriter(filePath);
            
            for (int x=0; x<pmList.size(); x++)
            {
                fw.write("Process Title: " + pmList.get(x).titleSentence.originalSentence + " [" + pmList.get(x).processID + "]" + System.lineSeparator());
                fw.write("Process Area: " + pmList.get(x).processArea + System.lineSeparator());
                fw.write("Process Description: " + pmList.get(x).descriptionSentence.originalSentence + System.lineSeparator()+ System.lineSeparator());
                
                for(int y=0; y<pmList.get(x).activityList.size(); y++)
                {
                  
                    fw.write(pmList.get(x).activityList.get(y).dump());
                    fw.write("-------------------------------------" + System.lineSeparator() + System.lineSeparator());  
                }
            }
            fw.close();
            
            ret = true;
        }
        catch (Exception e)
        {
            ret = false;
        }
        return ret;
    }
   
    
   
     
}
