/*

 */
package bretopidesktop;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import java.io.File;

/**
 * @author 
 */
public class LocalContext implements java.io.Serializable{
    
    public List<LocalContextEntity> projectList;
    public List<LocalContextEntity> processList;
    public List<LocalContextEntity> orgUnitList;
    public List<LocalContextEntity> orgPerformerList;
    public List<LocalContextEntity> orgRoleList;
    public List<LocalContextEntity> infoObjectList;
    public List<LocalContextEntity> systemList;
    public List<LocalContextEntity> productList;
    public List<LocalContextEntity> serviceList;
    
    public LocalContext(String xmlFilePath)
    {
        projectList = new ArrayList<LocalContextEntity>();
        processList = new ArrayList<LocalContextEntity>();
        orgUnitList = new ArrayList<LocalContextEntity>();
        orgPerformerList = new ArrayList<LocalContextEntity>();
        orgRoleList = new ArrayList<LocalContextEntity>();
        infoObjectList = new ArrayList<LocalContextEntity>();
        systemList = new ArrayList<LocalContextEntity>();
        productList = new ArrayList<LocalContextEntity>();
        serviceList = new ArrayList<LocalContextEntity>();
        populateFromXML(xmlFilePath);
        
       
    }
    
    // Get a LocalContextEntity with a given ID
    public LocalContextEntity getEntity(String id)
    {
        LocalContextEntity lce = new LocalContextEntity();
        
          for(int i=0; i<this.infoObjectList.size(); i++)
        {
          
            if(this.infoObjectList.get(i).id.equalsIgnoreCase(id))
            {
               
                lce.id = infoObjectList.get(i).id;
                lce.name = infoObjectList.get(i).name;
                lce.type = "Information Object";
              
            }
        }
        for(int i=0; i<this.orgPerformerList.size(); i++)
        {
            if(this.orgPerformerList.get(i).id.equalsIgnoreCase(id))
            {
                lce.id = orgPerformerList.get(i).id;
                lce.name = orgPerformerList.get(i).name;
                lce.type = "Performer";
                
            }
        }
        for(int i=0; i<this.orgRoleList.size(); i++)
        {
                if(this.orgRoleList.get(i).id.equalsIgnoreCase(id))
            {
                lce.id = orgRoleList.get(i).id;
                lce.name = orgRoleList.get(i).name;
                lce.type = "Role";
                
            }
        }
        for(int i=0; i<this.orgUnitList.size(); i++)
        {
                if(this.orgUnitList.get(i).id.equalsIgnoreCase(id))
            {
                
                lce.id = orgUnitList.get(i).id;
                lce.name = orgUnitList.get(i).name;
                lce.type = "Unit";
                
            }
        }
        for(int i=0; i<this.processList.size(); i++)
        {
                if(this.processList.get(i).id.equalsIgnoreCase(id))
            {
          
                lce.id = processList.get(i).id;
                lce.name = processList.get(i).name;
                lce.type = "Process";
 
            }
        }
        for(int i=0; i<this.productList.size(); i++)
        {
              if(this.productList.get(i).id.equalsIgnoreCase(id))
            {
          
                lce.id = productList.get(i).id;
                lce.name = productList.get(i).name;
                lce.type = "Product";
 
            }
            
        }
        for(int i=0; i<this.projectList.size(); i++)
        {
             if(this.productList.get(i).id.equalsIgnoreCase(id))
            {
          
                lce.id = projectList.get(i).id;
                lce.name = projectList.get(i).name;
                lce.type = "Project";
 
            }
            
        }
        for(int i=0; i<this.serviceList.size(); i++)
        {
                if(this.serviceList.get(i).id.equalsIgnoreCase(id))
            {
               
                lce.id = serviceList.get(i).id;
                lce.name = serviceList.get(i).name;
                lce.type = "Service";
              
            }
        }
        for(int i=0; i<this.systemList.size(); i++)
        {
                if(this.systemList.get(i).id.equalsIgnoreCase(id))
            {
                lce.id = systemList.get(i).id;
                lce.name = systemList.get(i).name;
                lce.type = "System";
            }
        }
      
        
        return lce;
    }
    
    
    // Identify the LocalContextEntites in a given Sentence (Named Entity Recognition)
    public void identifyEntities(bretopidesktop.Sentence s)
    {
        for(int i=0; i<this.infoObjectList.size(); i++)
        {
                 if(Common.containsWithoutCharacterBounds(s.originalSentence, this.infoObjectList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = infoObjectList.get(i).id;
                lce.name = infoObjectList.get(i).name;
                lce.type = "Information Object";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.orgPerformerList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.orgPerformerList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgPerformerList.get(i).id;
                lce.name = orgPerformerList.get(i).name;
                lce.type = "Performer";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.orgRoleList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.orgRoleList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgRoleList.get(i).id;
                lce.name = orgRoleList.get(i).name;
                lce.type = "Role";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.orgUnitList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.orgUnitList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgUnitList.get(i).id;
                lce.name = orgUnitList.get(i).name;
                lce.type = "Unit";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.processList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.processList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = processList.get(i).id;
                lce.name = processList.get(i).name;
                lce.type = "Process";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.productList.size(); i++)
        {
            if(Common.containsWithoutCharacterBounds(s.originalSentence, this.productList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                 lce.id = productList.get(i).id;
                lce.name = productList.get(i).name;
                lce.type = "Product";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.projectList.size(); i++)
        {
            if(Common.containsWithoutCharacterBounds(s.originalSentence, this.projectList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                 lce.id = projectList.get(i).id;
                lce.name = projectList.get(i).name;
                lce.type = "Project";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.serviceList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.serviceList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = serviceList.get(i).id;
                lce.name = serviceList.get(i).name;
                lce.type = "Service";
                s.localContextEntityList.add(lce);
            }
        }
        for(int i=0; i<this.systemList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s.originalSentence, this.systemList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = systemList.get(i).id;
                lce.name = systemList.get(i).name;
                lce.type = "System";
                s.localContextEntityList.add(lce);
            }
        }
 
        
    }
    
     // Identify the LocalContextEntites in a given Sentence (Named Entity Recognition)
    public String emphasizeEntitiesInString(String s)
    {
        for(int i=0; i<this.infoObjectList.size(); i++)
        {
            if(Common.containsWithoutCharacterBounds(s, this.infoObjectList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = infoObjectList.get(i).id;
                lce.name = infoObjectList.get(i).name;
                lce.type = "Information Object";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.orgPerformerList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s, this.orgPerformerList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgPerformerList.get(i).id;
                lce.name = orgPerformerList.get(i).name;
                lce.type = "Performer";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.orgRoleList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s, this.orgRoleList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgRoleList.get(i).id;
                lce.name = orgRoleList.get(i).name;
                lce.type = "Role";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.orgUnitList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s, this.orgUnitList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = orgUnitList.get(i).id;
                lce.name = orgUnitList.get(i).name;
                lce.type = "Unit";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.processList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s, this.processList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = processList.get(i).id;
                lce.name = processList.get(i).name;
                lce.type = "Process";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.productList.size(); i++)
        {
               if(Common.containsWithoutCharacterBounds(s, this.productList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = productList.get(i).id;
                lce.name = productList.get(i).name;
                lce.type = "Product";
                s = s + " " +  lce.type + " " + lce.name;
            }
           
        }
        for(int i=0; i<this.projectList.size(); i++)
        {
               if(Common.containsWithoutCharacterBounds(s, this.projectList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = projectList.get(i).id;
                lce.name = projectList.get(i).name;
                lce.type = "Project";
                s = s + " " +  lce.type + " " + lce.name;
            }
          
        }
        for(int i=0; i<this.serviceList.size(); i++)
        {
            if(Common.containsWithoutCharacterBounds(s, this.serviceList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = serviceList.get(i).id;
                lce.name = serviceList.get(i).name;
                lce.type = "Service";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        for(int i=0; i<this.systemList.size(); i++)
        {
                if(Common.containsWithoutCharacterBounds(s, this.systemList.get(i).name))
            {
                LocalContextEntity lce = new LocalContextEntity();
                lce.id = systemList.get(i).id;
                lce.name = systemList.get(i).name;
                lce.type = "System";
                s = s + " " +  lce.type + " " + lce.name;
            }
        }
        s.replace("\"", "");
        s.replace("\t", "");
         s.replace("\n", "");
        return s;
    }
    
    
    // Populate the LocalContext from a given XML file.
    public void populateFromXML(String filePath)
    {
         try 
        {
            LocalContextEntity lce = new LocalContextEntity();
            File fXmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);

            doc.getDocumentElement().normalize();

            System.out.println("Root element :" + doc.getDocumentElement().getNodeName());

            NodeList nList = doc.getElementsByTagName("local_context");

            System.out.println("----------------------------");

        
            for (int temp = 0; temp < nList.getLength(); temp++) 
            {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() == Node.ELEMENT_NODE) 
                {
                    Element eElement = (Element) nNode;
                    Element eSubElement;
                    
                    for (int indis=0; indis<eElement.getElementsByTagName("C_ORGANIZATIONAL_UNIT").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_ORGANIZATIONAL_UNIT").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.orgUnitList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_DOCUMENT").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_DOCUMENT").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.infoObjectList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_SERVICE").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_SERVICE").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.serviceList.add(lce);
                         
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_ROLE").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_ROLE").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.orgRoleList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_PROCESS").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_PROCESS").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.processList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_APPLICATION").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_APPLICATION").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.systemList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_INFRASTRUCTURE_ELEMENT").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_INFRASTRUCTURE_ELEMENT").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.systemList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_ACTOR").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_ACTOR").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.orgPerformerList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_PERFORMER").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_PERFORMER").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.orgPerformerList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_PERFORMANCE_INDICATOR").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_PERFORMANCE_INDICATOR").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.infoObjectList.add(lce);
                    }
                    for (int indis=0; indis<eElement.getElementsByTagName("C_PRODUCT").getLength(); indis++)
                    {
                        lce = new LocalContextEntity();
                        eSubElement = (Element) eElement.getElementsByTagName("C_PRODUCT").item(indis);
                        lce.name = eSubElement.getTextContent();
                        lce.id = eSubElement.getAttribute("id");
                        this.productList.add(lce);
                    }
                    
                }
                    
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
}
