/*
 * This project is created to demonstrate the Role Inconsistency detection.
 */
package bretopidesktop;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author 
 */
public class Demo_RoleInconsistency {
    
    private static String SERIALIZATION_DIRECTORY = "C:\\FOLDER\\"; // After each step of analysis the relevant objects are serialized.
    private static String ROLE_INCONSISTENCY_OUTPUT_HTML_PATH = "C:\\FOLDER\\Outputs\\role_inconsistencies.html"; // The output report is saved to this URL.
    private static String PROCESS_MODEL_XML_INPUT_FOLDER_PATH = "C:\\FOLDER\\Processes\\"; // The URL of the folder that contains process models 
    private static String LOCAL_CONTEXT_XML_INPUT_FILE_PATH = "C:\\FOLDER\\Inputs\\local_context.xml"; // URL of the organizational entity catalog. 


    private static LocalContext lContext; // Load the local context as a global object
    
    public static void main(String[] args) throws FileNotFoundException 
    {
         // 1. CREATE CANONICAL INPUT REPRESENTATIONS
        // 1.A. BUILD THE LOCAL CONTEXT AND THE ABBREVIATIONS LIST
        Common.log("Building the local context...");
        LOCAL_CONTEXT_XML_INPUT_FILE_PATH = "C:\\FOLDER\\Inputs\\local_context_TUe.xml";
        lContext = new LocalContext(LOCAL_CONTEXT_XML_INPUT_FILE_PATH); 
        Common.log("Local context build complete.");
        

         // ROLE INCONSISTENCY DEMO
        List<ProcessModel> pmList = new ArrayList<ProcessModel>(); 
 
        pmList = Common.deserializePmList(SERIALIZATION_DIRECTORY + "pmlist_.ser");

         // Identify local context entities and abbreviations in ProcessModels
        for (int x=0; x<pmList.size(); x++) // for each process model
        {
            Common.log(x + " of " + pmList.size());
            lContext.identifyEntities(pmList.get(x).descriptionSentence);
            for (int i=0; i<pmList.get(x).activityList.size(); i++) // for each activity
            {
                lContext.identifyEntities(pmList.get(x).activityList.get(i).labelSentence);
                lContext.identifyEntities(pmList.get(x).activityList.get(i).descriptionSentence);

            }
        }
        Common.serializeObj(pmList, SERIALIZATION_DIRECTORY + "pmlist_step4.ser");
         Common.log("Local context entity recognition on process models complete");

        RoleInconsistencyAnalyzer.writeToHTMLFileFancy(pmList, ROLE_INCONSISTENCY_OUTPUT_HTML_PATH, lContext);

    }
        
}
